IF NOT EXISTS
(
	SELECT *
	FROM EST_PARAM_COMPRAS_PERFIL_TAMANHO
	WHERE CD_PERFIL_TAMANHO = 1
)
	BEGIN
		INSERT INTO EST_PARAM_COMPRAS_PERFIL_TAMANHO
		(DS_PERFIL_TAMANHO
	   , CD_USU
	   , DT_CAD
	   , DT_ULT_ALT
		)
			   SELECT 'NAO DEFINIDO'
					, 1
					, CONVERT( CHAR(10), GETDATE(), 112)
					, GETDATE();
	END;

IF NOT EXISTS
(
	SELECT *
	FROM EST_PARAM_COMPRAS_PERFIL_DEMOGRAFICO
	WHERE CD_PERFIL_DEMOGRAFICO = 1
)
	BEGIN
		INSERT INTO EST_PARAM_COMPRAS_PERFIL_DEMOGRAFICO
		(DS_PERFIL_DEMOGRAFICO
	   , CD_USU
	   , DT_CAD
	   , DT_ULT_ALT
		)
			   SELECT 'NAO DEFINIDO'
					, 1
					, CONVERT( CHAR(10), GETDATE(), 112)
					, GETDATE();
	END;

INSERT INTO EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL
(CD_EMP
, CD_FILIAL
, CD_PERFIL_DEMOGRAFICO
, CD_PERFIL_TAMANHO
, CD_USU
, DT_CAD
)
	   SELECT PRC_FILIAL.CD_EMP
			, PRC_FILIAL.CD_FILIAL
			, 1
			, 1
			, 1
			, CONVERT( CHAR(10), GETDATE(), 112)
	   FROM PRC_FILIAL
			LEFT OUTER JOIN EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL ON PRC_FILIAL.CD_EMP = EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_EMP
																   AND PRC_FILIAL.CD_FILIAL = EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_FILIAL
	   WHERE EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_FILIAL IS NULL;


--Perfil Inicial do sistema de filial


IF NOT EXISTS
(
	SELECT *
	FROM EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO
	WHERE HISTORICO = 'PERFIL INICIAL DO SISTEMA DE FILIAL'
)
	BEGIN
		--INSERINDO LOTE DE TRANSACA INICIAL

		INSERT INTO EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO
		(HISTORICO
	   , CD_USU
	   , DT_CAD
	   , STS_LOTE
		)
			   SELECT 'PERFIL INICIAL DO SISTEMA DE FILIAL'
					, 1
					, GETDATE()
					, 0;

		--INSERINDO PERFIL INICIAL

		INSERT INTO EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_PERFIL
		(cd_ctr
	   , CD_PERFIL_TAMANHO
	   , CD_PERFIL_DEMOGRAFICO
		)
			   SELECT IDENT_CURRENT('EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO')
					, 1
					, 1;

		INSERT INTO EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_PRC_FILIAL
		(cd_ctr
	   , CD_EMP
	   , CD_FILIAL
		)
			   SELECT IDENT_CURRENT('EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO')
					, P.CD_EMP
					, P.CD_FILIAL
			   FROM PRC_FILIAL p
					LEFT OUTER JOIN EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL pf ON p.CD_EMP = pf.CD_EMP
																			  AND p.CD_FILIAL = pf.CD_FILIAL
			   WHERE pf.CD_FILIAL IS NULL;
	END;

--PERFIL INICIAL 


INSERT INTO EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL
(CD_EMP
, CD_FILIAL
, CD_PERFIL_DEMOGRAFICO
, CD_PERFIL_TAMANHO
, CD_USU
, DT_CAD
)
	   SELECT PRC_FILIAL.CD_EMP
			, PRC_FILIAL.CD_FILIAL
			, 1
			, 1
			, 1
			, CONVERT( CHAR(10), GETDATE(), 112)
	   FROM PRC_FILIAL
			LEFT OUTER JOIN EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL ON PRC_FILIAL.CD_EMP = EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_EMP
																   AND PRC_FILIAL.CD_FILIAL = EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_FILIAL
	   WHERE EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL.CD_FILIAL IS NULL;


--Perfil Inicial do sistema de produto


IF NOT EXISTS
(
	SELECT *
	FROM EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO
	WHERE HISTORICO = 'PERFIL INICIAL DO SISTEMA DE PRODUTO'
)
	BEGIN

		--INSERINDO LOTE DE TRANSACA INICIAL

		INSERT INTO EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO
		(HISTORICO
	   , CD_USU
	   , DT_CAD
	   , STS_LOTE
		)
			   SELECT 'PERFIL INICIAL DO SISTEMA DE PRODUTO'
					, 1
					, GETDATE()
					, 0;

		--INSERINDO PERFIL INICIAL

		INSERT INTO EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_PERFIL
		(cd_ctr
	   , CD_PERFIL_TAMANHO
	   , CD_PERFIL_DEMOGRAFICO
		)
			   SELECT IDENT_CURRENT('EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO')
					, 1
					, 1;

		INSERT INTO EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_EST_PROD
		(cd_ctr
	   , CD_EMP
	   , CD_PROD
		)
			   SELECT IDENT_CURRENT('EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO')
					, CD_EMP
					, CD_PROD
			   FROM EST_PROD;
	END;

--Aplicando lote de perfil criado


EXEC P_EST_PARAM_COMPRAS_PERFIL_EST_PROD_APLICAR;

EXEC P_EST_PARAM_COMPRAS_PERFIL_PRC_FILIAL_APLICAR;

--Fechar lote de filial que nao possui filial sem perfil


UPDATE L
  SET
	  L.STS_LOTE = 1
FROM EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO L
	 LEFT OUTER JOIN EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_PRC_FILIAL P ON L.CD_CTR = P.CD_CTR
WHERE L.STS_LOTE = 0
	  AND P.CD_FILIAL IS NULL;

--Fechar lote de produto que nao possui produto sem perfil


UPDATE L
  SET
	  L.STS_LOTE = 1
FROM EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO L
	 LEFT OUTER JOIN EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_EST_PROD P ON L.CD_CTR = P.CD_CTR
WHERE L.STS_LOTE = 0
	  AND P.CD_PROD IS NULL;